<?php
/* @var $tura_aktywna boolean */
/* @var $zlecenia ZlecenieFirmy[] */
/* @var $this MainController */

$GRADIENT = array(
	array('value'=>0.00,'color'=>array(255,000,000)),
	array('value'=>0.60,'color'=>array(255,000,000)),
	array('value'=>0.75,'color'=>array(255,255,000)),
	array('value'=>0.95,'color'=>array(000,255,000)),
	array('value'=>1.00,'color'=>array(000,255,000)),
);

function assignedToYou(ZlecenieFirmy &$task)
{
	return $task->idUcznia == Yii::app()->user->id || $task->idGrupyPrzetargowej ? '' : ' style="display:none" ';
}
?>

<style type="text/css">
	#zleceniaInterior .disabled {color: gray}
	#zleceniaInterior tbody td {padding: 8px}
	#zleceniaInterior tr.selected {background-color: rgba(255, 255, 0, 0.4)}
	#zleceniaInterior tr.done {background-color: rgba(0, 255, 0, 0.4)}
	#zleceniaInterior tr.wrong {background-color: rgba(255, 0, 0, 0.4)}
	#zleceniaInterior tr:hover {background-color: rgba(127, 127, 127, 0.4)}
	#zleceniaInterior .bar {
		text-align: left;
		font-weight: bold;
		padding: 10px;
		font-size: larger;
		cursor: pointer;
	}
	#zleceniaInterior .bar > .desc {
		padding-left: 22px;
		font-style: italic;
		font-size: small;
		font-weight: normal;
		cursor: pointer;
	}
	#zleceniaInterior .bar:before {
		content: '▼';
		width: 20px;
		display: inline-block;
		padding: 0;
		margin: 0;
	}
	#zleceniaInterior .bar.fold:before {
		content: '▶';
		width: 20px;
		display: inline-block;
		padding: 0;
		margin: 0;
	}
	#zleceniaInterior td {text-align: center}
	#zleceniaInterior .taskList::-webkit-scrollbar {width: 12px}
	#zleceniaInterior .taskList::-webkit-scrollbar-track {background-color: #eaeaea;border-left: 1px solid #ccc}
	#zleceniaInterior .taskList::-webkit-scrollbar-thumb {background-color: #ccc}
	#zleceniaInterior .taskList::-webkit-scrollbar-thumb:hover {background-color: #aaa}
	#zleceniaInterior .taskList {height: calc(100% - 35px);overflow: auto}
</style>

<div id="zleceniaInterior" class="sticker" canvasX="670" canvasY="100" canvasWidth="650" canvasHeight="900">
	<div id="zadaniaHomeWork" style="height:100%">
		<h1 style="height:35px">Zlecenia <?php if (count($zlecenia)) : ?> (<span id="zadaniaTaskCounter"><?php echo $TASK_NUM; ?></span>/<?php echo $MAX_TASKS; ?>) <?php endif; ?></h1>
		<div class="taskList">
		<?php

			$data = null;
			$task = null;

			foreach ($zlecenia as $index => $zlecenie) :
				/* @var $zlecenie ZlecenieFirmy */
				$selected = !empty($zlecenie->czasPodjecia) && empty($zlecenie->idGrupyPrzetargowej);

				$currDate = strftime('%A %d %B %Y', strtotime($zlecenie->czasPodjecia));

				$currType = empty($zlecenie->idGrupyPrzetargowej);
				if (is_null($task)) $task = $currType;

				if ($currDate != $data || $task != $currType) :
					if ($index) :
						echo '</tbody></table></div>';
					endif;
					$data = $currDate;
					$task = $currType;
					echo '<div class="bar ' . ($index ? 'fold' : 'unfold') . '">' . $data;
					if ($zlecenie->idGrupyPrzetargowej)
					{
						if ($zlecenie->tenderGroup->status == PrzetargGrupa::TENDER_STATUS_SUCCESS)
							$status = ' (Wykonany!)';
						else if ($zlecenie->tenderGroup->status == PrzetargGrupa::TENDER_STATUS_FAILED)
							$status = is_null($zlecenie->tenderGroup->zgloszone) ? ' (Niewykonany)' : ' (Niewykonany - oczekuje na decyzję Komisji odwoławczej)';
						else
							$status = '';
						echo '<div class="desc">Przetarg dla ' . $zlecenie->tenderGroup->przetarg->kontrahent->nazwa . $status . '</div>';
					}
					echo '</div><div' . ($index ? ' style="display:none"' : '') . '><table><tbody>';
				endif;
		?>
				<tr row-task-id="<?php echo $zlecenie->id; ?>" <?php
					if ($zlecenie->isOpen) echo 'class="selected"';
					elseif ($zlecenie->isDone) echo 'class="done"';
					elseif ($zlecenie->isWrong) echo 'class="wrong"';
				?>>
					<td>
						<img src="<?php echo $zlecenie->idZlecenia0->dziedzina->namesAsImageUrl; ?>"
								 title="<?php echo $zlecenie->idZlecenia0->dziedzina->nazwa; ?>"
								 alt="<?php echo $zlecenie->idZlecenia0->dziedzina->nazwa; ?>">
					</td>
					<td style="text-align:left">
						<div style="font-size:130%"><?php echo $zlecenie->idZlecenia0->dziedzina->nazwa; ?> - <?php echo $zlecenie->idZlecenia0->kategoria; ?> (<?php echo $zlecenie->idZlecenia0->poziomStr; ?>)</div>
						<div>
							<?php echo $zlecenie->idGrupyPrzetargowej ? 'Przetarg dla ' : 'Od' ?> <?php echo $zlecenie->kontrahent->nazwa; ?> /
							<?php echo $zlecenie->intervalString ?>
						</div>
						<?php if (empty($zlecenie->idGrupyPrzetargowej)) : ?>
						<div>
							<span style="color:blue"><?php echo $zlecenie->idZlecenia0->cena; ?> zł netto</span> /
							<strong style="color:red"><?php echo $zlecenie->idZlecenia0->kara; ?>%
							(<?php echo $zlecenie->idZlecenia0->kwotaKary; ?> zł)</strong> /
							<span style="color:black"><?php echo $zlecenie->idZlecenia0->czasTrwaniaStr; ?></span>
						</div>
						<?php endif; ?>
						<?php
							echo '<div>Przydzielone do: ' . $zlecenie->assignedWorkerName . '</div>';
						?>
					</td>
					<td>
						<?php if ($zlecenie->isWrong) : ?>
							<strong><?php echo empty($zlecenie->odpowiedz) ? 'Nie udzielono<br/>odpowiedzi' : 'Błędna odpowiedź' ?></strong>
						<?php elseif ($zlecenie->isDone) : ?>
							<strong>Wykonane<br/>poprawnie!</strong>
						<?php elseif ($zlecenie->isOpen && !$tura_aktywna) : ?>
							<a <?php echo assignedToYou($zlecenie); ?>
								taskId="<?php echo $zlecenie->id; ?>"
								class="zadanieContinueTask buttonS bRed" href="#">Kontynuj</a>
						<?php elseif (!$zlecenie->isOpen && !$tura_aktywna) : ?>
							<a <?php echo assignedToYou($zlecenie); ?>
								taskId="<?php echo $zlecenie->id; ?>"
								class="zadanieBeginTask buttonS bRed" href="#">Rozpocznij</a>
						<?php endif; ?>
					</td>
				</tr>
		<?php endforeach; echo '</tbody></table></div>'; ?>
			</div>
	</div>

<?php if (!$tura_aktywna) : ?>
	<div id="zadanieHomeWorkTask" style="display:none;">
		<h1 style="height:50px;line-height:50px">
			<a id="zadanieHomeWorkTaskBack" href="#">&#8656;</a>
			<span id="zadanieHomeWorkTaskTitle"></span>
			<div style="display:inline;float:right;position:relative;height:50px;width:50px" id="zadanieTimerContainer"></div>
		</h1>
		<div id="zadanieHomeWorkTaskImg" style="text-align:center;display:none">
			<img src="" style="max-width:500px;max-height:512px;border-width:1px"/>
		</div>
		<div style="margin-top:25px;margin-bottom:25px;font-size:large" id="zadanieHomeWorkTaskContent"></div>
		<div>
			<input type="text" value="" id="zadanieHomeWorkTaskAnser"/><span id="zadanieHomeWorkUnit"></span>
			<button id="zadanieHomeWorkTaskSubmit" class="bBlue buttonS">Odpowiedź</button>
			<div id="waitGif" style="display:none;vertical-align: middle; margin: -20px 0 0 -20px"></div>
		</div>
	</div>
<?php endif; ?>

	<?php echo CHtml::scriptFile(Yii::app()->baseUrl . '/js/lib/jquery.knob.js'); ?>
	<script type="text/javascript">
	(function(){
		window.taskIdToReport = 0;
		$('#zleceniaInterior .bar').click(function(){
			if ($(this).hasClass('fold')) {
				$(this).next().slideDown();
				$(this).removeClass('fold');
			}
			else {
				$(this).next().slideUp();
				$(this).addClass('fold');
			}
		});

		function enableLinks(enable)
		{
			var links = $('#zadanieHomeWorkTaskSubmit, #zadanieHomeWorkTaskAnser, '
				+ '#zadanieHomeWorkTaskBack, .zadanieContinueTask, .zadanieBeginTask, '
				+ '.zadanieDeselectTask, .zadanieSelectTask, select[data-task-id]');
			if (enable) {
				//links.prop('disabled', true);
				links.removeClass('disabled');
			}
			else {
				//links.prop('disabled', false); //removeProp('disabled');
				links.addClass('disabled');
			}
		}

		$('body').on('click','.reportSolution', function(){
			var $this = $(this);
			var taskId = window.taskIdToReport;

			$.ajax({
				type: 'POST',
				url: '<?php echo $this->createUrl('/student/tasks/ajaxReportSolution'); ?>',
				data: {
					taskId: taskId
				},
				success: function(){
					$('.reportText').empty().text('Twoja odpowiedź została przekazana do Komisji odwoławczej.');
				},
			});

			return false;
		});

		$('body').on('click','#reportAuction-'+window.taskIdToReport, function(){
			var $this = $(this);
			var taskId = window.taskIdToReport;
			console.log(taskId);

			$.ajax({
				type: 'POST',
				url: '<?php echo $this->createUrl('/student/tasks/ajaxReportAuction'); ?>',
				data: {
					taskId: taskId
				},
				success: function(){
					$('.reportText').empty().text('Twoje zgłoszenie zostało przekazane do Komisji odwoławczej.');
				},
			});

			return false;
		});

function interiorZleceniaInit(TASK_NUM, MAX_TASKS)
{
	var currentTaskInterval = null;
	var timerInterval = null;
	var currentTaskId = null;

	window.addEventListener('hashchange', function() {
		clearInterval(currentTaskInterval);
		clearInterval(timerInterval);
		currentTaskId = null;
	});

	function finishTask(data)
	{
		var taskId = currentTaskId;
		window.taskIdToReport = taskId;
		var cnt = parseInt($('#tasks-counter').text());
		if (isNaN(cnt)) cnt = 0; else {cnt--; if (cnt <= 0) cnt = 0;}
		$('#tasks-counter').text(cnt);
		if (cnt <= 0) $('#tasks-counter').fadeOut();
		if (data.status == 0) {
			var row = $('tr[row-task-id="' + taskId + '"]');
			row.removeClass();
			row.addClass('wrong');
			$('a[taskId="' + taskId + '"]').parent().html('<strong>Wykonane<br/>niepoprawnie</strong><br/>');
			var message;
			if(data.you)
				message = 'Niestety nie udało Ci się wykonać prawidłowo tego zlecenia.';
			else if(data.uczen && data.tenderStatus == undefined)
				message = 'Niestety ' + data.uczen + ' nie wykonał(a) prawidłowo zlecenia.';
			else
				message = 'Niestety, zlecenie nie zostało prawidłowo wykonane.';
			console.log(data);
			if (data.booknote && data.tenderStatus == undefined) {
				var url = window.links.studentBooknote.replace('_BOOKNOTE_ID_', data.booknote);
				message += '<br/><br/>' +
					'Zgodnie z zawartą umową zleceniodawca nakłada na twoją firmę karę. Notę obciążeniową możesz podejrzeć ' +
					'<a target="_blank" href="' + url + '">tutaj</a><br/><br/>' +
					'Udzielona odpowiedź: ' + data.answer + '<br/>Możliwe odpowiedzi: ' + data.answers + '<br/><br/>' +
					'<span class="reportText">Jeżeli uważasz, że Twoja odpowiedź jest poprawna, zgłoś to do Komisji odwoławczej, klikając tutaj: <a href="#" class="reportSolution">Zgłoś do komisji odwoławczej</a></span>.';
			}
						showMessage('Zadanie niewykonane', message, {close:function(){
				if (data.bankrut)
					bankrutDialogOpen(true);
				if(data.tenderStatus == 5) {
					var linkAuctionReportId = 'reportAuction-'+taskId;
					message = 'Niestety ilość dopuszczalnych zadań źle rozwiązanych została przekroczona. Przetarg zakończył się niepowodzeniem.' +
							'<br/><br/><span class="reportText"><a href="#" id="'+linkAuctionReportId+'">Zgłoś do Komisji odwoławczej</a></span>';
					showMessage('Przetarg niewykonany', message, {close:function(){
						var $rows = $('#zadaniaHomeWork tr[class!="wrong"]');
						$('#zadaniaHomeWork tr[class!="wrong"] a.zadanieBeginTask').parent().html('<strong>Wykonane<br/>niepoprawnie</strong>');
						$rows.removeClass();
						$rows.addClass('wrong');
					}});
				}
			}});
			$('#zadanieHomeWorkTaskBack').click();
		}
		else if (data.status == 1) {
			var row = $('tr[row-task-id="' + taskId + '"]');
			row.removeClass();
			row.addClass('done');
			$('a[taskId="' + taskId + '"]').parent().html('<strong>Wykonane<br/>poprawnie</strong>');
			var message = data.you ? 'Gratulacje! Udało Ci się wykonać zlecenie.' :
				('Gratulacje! ' + data.uczen + ' poprawnie rozwiązał(a) zlecenie.');
			if (data.invoice && !data.przetarg) {
				var url = window.links.studentInvoice.replace('_INVOICE_ID_', data.invoice);
				message += '<br/><br/>' +
					'Na konto twojej firmy wkrótce wpłyną środki. Fakturę możesz podejrzeć ' +
					'<a target="_blank" href="' + url + '">tutaj</a>.';
			}
			showMessage('Zadanie wykonane', message);
			$('#zadanieHomeWorkTaskBack').click();
		}
	}

	function submitAnser()
	{
		//console.log('submit ' + currentTaskId + ' ' + odpowiedz);
		clearInterval(currentTaskInterval);
		clearInterval(timerInterval);
		enableLinks(false);
		var odpowiedz = $('#zadanieHomeWorkTaskAnser').val();
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxSubmitTask,
			data: {
				answer: odpowiedz,
				taskId: currentTaskId
			},
			success: finishTask,
			error: function(xhr, status, error) {
				showMessage('Błąd', status + ' ' + error);
			},
			complete: function() {
				enableLinks(true);
			}
		});
	}

	//wysyla odpowiedz
	$('#zadanieHomeWorkTaskSubmit').click(function(){
		clearTimeout(window.taskChangedTimeout);
		submitAnser();
		return false;
	});

	//cofa z taksa do listy
	$('#zadanieHomeWorkTaskBack').click(function(){
		clearInterval(currentTaskInterval);
		clearInterval(timerInterval);
		currentTaskId = null;
		$('#zadanieHomeWorkTask').fadeOut(400, function(){
			$('#zadaniaHomeWork').fadeIn();
		});
		return false;
	});

	//odpowiedź została zmieniona wyślij na serwer
	$('#zadanieHomeWorkTaskAnser').change(function(){
		var odp = $(this).val();
		var opts = {
			segments: 12,
			steps: 3,
			opacity: 0.3,
			width: 4,
			space: 0,
			length: 5,
			color: '#637a61',
			speed: 1.5,
		};
		window.taskChangedTimeout = setTimeout(function(){
			$('#waitGif').show().activity(opts);
			//zablokuj linki
			enableLinks(false);
			//console.log('send answer: ' + odp);
			$.ajax({
				url: window.links.studentAjaxSubmitAnswer,
				global: false,
				type: 'POST',
				data: {
					taskId: currentTaskId,
					answer: odp
				},
				complete: function() {
					//console.log('send answer: ' + odp + ' DONE');
					enableLinks(true);
					$('#waitGif').hide().activity(false);
				}
			});
		}, 300);
	});

	//klikniecie na rozpocznyj lub kontynuj
	$('.zadanieBeginTask, .zadanieContinueTask').click(function(){

		var jThis = $(this);
		enableLinks(false);
		currentTaskId = jThis.attr('taskId');
//		var currentTs = new Date().getTime()/1000;
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxBeginTask,
			data: {
				taskId: currentTaskId,
//				timeStamp: currentTs
			},
			success: function(data){
				//console.log(data);
				if (data.status == 2) {	//zadanie można rozwiązywać
					jThis.text('Kontynuj');
					jThis.parent().parent().removeClass();
					jThis.parent().parent().addClass('selected');
					$('#zadaniaHomeWork').fadeOut(400, function(){

						$('#zadanieHomeWorkTaskTitle').text(data.dziedzina + ' - '+ data.zadanie.kategoria);
						$('#zadanieHomeWorkTaskContent').html(data.zadanie.tresc);
						if (data.zadanie.urlObrazka) {
							$('#zadanieHomeWorkTaskImg img').attr('src', data.zadanie.urlObrazka);
							$('#zadanieHomeWorkTaskImg').css('display', 'block');
						}
						else $('#zadanieHomeWorkTaskImg').css('display', 'none');
						$('#zadanieHomeWorkTaskAnser').val(data.odpowiedz);
						if (data.zadanie.jednostka != null && data.zadanie.jednostka.length)
							$('#zadanieHomeWorkUnit').text(' [' + data.zadanie.jednostka + ']');
						else
							$('#zadanieHomeWorkUnit').text('');
//console.log(data.odpowiedz);
						//setup interval
						var czas = parseInt(data.zadanie.czas);

						//var currentTs = new Date().getTime();
						//$.ajax({ url: window.links.studentAjaxGetTime, async: false, global: false, success: function(rt) { currentTs = rt; } });

						/*
						var currentT = new Date();
						var currentTs = 0;
        					$.ajax({ url: window.links.studentAjaxGetTime, async: false, global: false, type: 'GET', success: function(res) {
							currentT.setTime(res);
							currentTs = currentT.getTime();
						}
						});
						*/
//						currentTs = new Date().getTime()/1000;
						currentTs = data.timeStamp;

						var CurrT = data.czasRozpoczecia + czas - currentTs; // /1000
						var PassT = currentTs - data.czasRozpoczecia; //currentTs/1000

						currentTaskInterval = setInterval(function() {
							clearInterval(currentTaskInterval);
							submitAnser();
							$('#zadanieTimer').val(0).trigger('change');
						}, Math.floor(CurrT*1000));

						//setup timer
						var timerContainer = $('#zadanieTimerContainer');
						timerContainer.html('');
						$('<input id="zadanieTimer" value="' + Math.floor(PassT) + '" />').knob({
							min: 0,
							max: czas,
							thickness: 0.2,
							readOnly: true,
							width: 50,
							height: 50,
							displayInput: false,
							bgColor: 'rgba(0, 255, 0, 0.3)'
						}).appendTo(timerContainer).val(Math.floor(PassT)).trigger('change')
							.css('position','absolute').css('top','0').css('left','0');
						timerContainer.append('<div id="zadanieTimerCnt" style="text-shadow: 1px 1px black;font-size:12px;font-weight:bold;width:50px;height:50px;position: absolute;left:0;top:0px;padding: 0;margin:  0;line-height:  50px;display:table-cell;vertical-align:middle;text-align:center">' + formatInterval(Math.floor(CurrT)) + '</div>');
						timerInterval = setInterval(function(){
//							var currentTs = new Date().getTime()/1000;
							var currentTs;
							$.ajax({ url: window.links.studentAjaxGetTime, async: false, global: false, success: function(rt) { currentTs = rt/1000; } })
//							console.log(currentTs);
//							var currentTs = data.timeStamp;
							var dt = Math.floor((data.czasRozpoczecia + czas - currentTs)); // currentTs/1000
							var PassT = currentTs - data.czasRozpoczecia; //currentTs/1000
							if (dt < 0) dt = 0;
							if (dt <= 30) {
								$('#zadanieTimer').trigger('configure', {
									fgColor: '#FF0000',
								});
								$('#zadanieTimerCnt').css('color', 'red');
							}
							$('#zadanieTimer').val(PassT).trigger('change');
							$('#zadanieTimerCnt').text(formatInterval(dt));
						}, 333);

						$('#zadanieHomeWorkTask').fadeIn();
					});
				}
				else finishTask(data)
			},
			error: function(xhr, status, error){
				currentTaskId = null;
				showMessage('Błąd', status + ' ' + error);
			},
			complete: function() {
				enableLinks(true);
			}
		});
		return false;
	});

}

		interiorZleceniaInit(<?php echo $TASK_NUM; ?>, <?php echo $MAX_TASKS; ?>);

		$('select[data-task-id]').change(function(){
			var _this = $(this); var params = {};
			params.taskId = _this.attr('data-task-id');
			var id = _this.val();
			if (id.indexOf('s') === 0)
				params.studentId = id.substring(1);
			else if (id.indexOf('w') === 0)
				params.workerId = id.substring(1);
			function undo() {_this.val(_this.attr('data-old'));}
			enableLinks(false);
			$.ajax({
				type: 'POST', data: params,
				url: window.links.studentAjaxAssignTask,
				success: function(data){
					if (data.error) {
						showMessage('Błąd', data.error);
						undo();
					}
					else {
						_this.attr('data-old', id);
						_this.siblings('.stats').remove();
						if (params.studentId == window.userdata.userId)
							$('a.zadanieContinueTask[taskid="'+params.taskId+'"], a.zadanieBeginTask[taskid="'+params.taskId+'"]').fadeIn();
						else
							$('a.zadanieContinueTask[taskid="'+params.taskId+'"], a.zadanieBeginTask[taskid="'+params.taskId+'"]').fadeOut();
						if (data.stats) {
							var s = data.stats;
							var durationColor;
							if (s.duration < s.taskEnd)
								durationColor = 'green';
							else if (s.duration > s.taskEnd)
								durationColor = 'red';
							else
								durationColor = 'yellow';
							var gradient = <?php echo json_encode($GRADIENT) ?>;
							var color = [0, 0, 0];
							for (var i=0; i<gradient.length-1; i++) {
								var A = gradient[i];
								var B = gradient[i+1];
								if (s.propability >= A.value && s.propability <= B.value) {
									var sum = (B.value - A.value);
									var a = 1 - (s.propability - A.value) / sum;
									var b = 1 - (B.value - s.propability) / sum;
									color = [
										Math.round(a * A.color[0] + b * B.color[0]),
										Math.round(a * A.color[1] + b * B.color[1]),
										Math.round(a * A.color[2] + b * B.color[2])
									];
									break;
								}
							}
							var html = '<span style="padding-left:5px;font-weight:bold;" class="stats"><span style="color:' + durationColor + '">'
								+ s.duration + ' ' + s.durationUnit + '</span> <span style="text-shadow:1px 1px 2px black;color:rgb('+color[0]+', '+color[1]+', '+color[2]+')">'
								+ Math.round(s.propability*100) + '%</span></span>';
							_this.after(html);
						}
					}
				},
				error: function() {undo();},
				complete: function() {enableLinks(true);}
			});
		});

	})();
	</script>

</div>
